<?php
$block_style = $settings['block_style'];
$posts_per_page = $settings['query_posts_per_page'];
$post_categories = $settings['query_post_categories'];
$post_tags = $settings['query_post_tags'];
$orderby = $settings['query_orderby'];
$order = $settings['query_order'];
$post_format = $settings['query_post_format'];

$desktop_column_number = ( isset($settings['layout_column_number']) ) ? $settings['layout_column_number']: 3;
$tablet_column_number = ( isset($settings['layout_column_number_tablet']) ) ? $settings['layout_column_number_tablet']: 2; 
$mobile_column_number = ( isset($settings['layout_column_number_mobile']) ) ? $settings['layout_column_number_mobile']: 1;

$column_desktop = round(12 / (int)$desktop_column_number);
$column_tablet = round(12 / (int)$tablet_column_number);
$column_mobile = round(12 / (int)$mobile_column_number);

$args = array(
    'posts_per_page' => $posts_per_page,
    'orderby' => $orderby,
    'order' => $order
);

if (!empty($post_categories)) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'category',
            'terms' => $post_categories,
            'field' => 'id'
        ),
    );
}

if (!empty($post_tags)) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'post_tag',
            'terms' => $post_tags,
            'field' => 'id'
        ),
    );
}

if (in_array('video', $post_format) && !in_array('standard', $post_format)) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'post_format',
            'field' => 'slug',
            'terms' => array('post-format-video'),
            'operator' => 'IN'
        )
    );
}

if ($settings['query_enable_offset'] == 'yes') {
    $args['offset'] = $settings['query_offset_item_num'];
}

$query = get_posts($args);
?>
<?php if ($query) { ?>

    <div class="qoxag-wrapper qoxag-post-block">
        <div class="row">
            <?php
            foreach ($query as $key => $post) {
                $postid = $post->ID;
                include QOXAG_CORE . "/elementor/content-parts/content-{$block_style}.php";
            }
            ?>
        </div>
        <!-- content will be here -->
    </div>
<?php } ?>